<?php

namespace App\Models\Tenants;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmergencyContact extends Model 
{

    protected $table = 'emegency_contacts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'relation', 'name', 'mobile', 'email', 'fax');
    protected $visible = array('user_id', 'relation', 'name', 'mobile', 'email', 'fax');

    public function user()
    {
        return $this->hasOne('App\User', 'user_id');
    }

}